<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escanear Ticket</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script src="https://unpkg.com/jsqr/dist/jsQR.js"></script>
</head>
<body>
    <?php include "menuajuste.php"; ?>

    <div class="content">
        <h1 class="text-center mb-4">Escanear Ticket</h1>

        <!-- Instrucciones -->
        <p class="text-center">Apunta la cámara hacia el código QR del ticket para escanearlo.</p>

        <!-- Video de la cámara -->
        <div class="text-center">
            <video id="video" width="300" height="200" style="border: 1px solid black;"></video>
        </div>

        <form action="solicitudes/scan_ticket.php" method="POST" class="mt-3">
            <input type="hidden" id="codigo_ticket" name="codigo_ticket">
            <div class="d-grid">
                <button type="submit" class="btn btn-primary">Escanear Ticket</button>
            </div>
        </form>
    </div>

    <script>
        const video = document.getElementById('video');
        const canvasElement = document.createElement('canvas');
        const canvas = canvasElement.getContext('2d');
        const codigoTicketInput = document.getElementById('codigo_ticket');

        // Acceder a la cámara
        navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
            .then((stream) => {
                video.srcObject = stream;
                video.setAttribute('playsinline', true); // Necesario para que funcione en dispositivos iOS
                video.play();
                requestAnimationFrame(scanQRCode);
            })
            .catch((err) => {
                alert("No se pudo acceder a la cámara: " + err);
            });

        // Función para escanear el código QR
        function scanQRCode() {
            if (video.readyState === video.HAVE_ENOUGH_DATA) {
                canvasElement.height = video.videoHeight;
                canvasElement.width = video.videoWidth;
                canvas.drawImage(video, 0, 0, canvasElement.width, canvasElement.height);
                const imageData = canvas.getImageData(0, 0, canvasElement.width, canvasElement.height);
                const code = jsQR(imageData.data, canvasElement.width, canvasElement.height, {
                    inversionAttempts: "dontInvert",
                });

                if (code) {
                    // Colocar el código QR en el campo oculto del formulario
                    codigoTicketInput.value = code.data;
                    console.log("Código QR escaneado:", codigoTicketInput.value);
                    // Detener la cámara y enviar el formulario
                    video.srcObject.getTracks().forEach(track => track.stop());
                    document.forms[0].submit();
                } else {
                    requestAnimationFrame(scanQRCode); // Continuar escaneando
                }
            } else {
                requestAnimationFrame(scanQRCode); // Continuar escaneando
            }
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
